package com.gugawag.bancos.gui;

import com.gugawag.bancos.Apolice;
import com.gugawag.bancos.BancoInvest;
import com.gugawag.bancos.BancoSeguros;
import com.gugawag.bancos.Poupanca;
import com.gugawag.bancos.auditoria.AuditorGenerico;

public class AppAuditoria {
	public static void main(String[] args) {
		BancoInvest itau = new BancoInvest();
		itau.inserir(new Poupanca("1", 100));
		itau.inserir(new Poupanca("2", 20000));

		BancoSeguros seguroSA = new BancoSeguros();
		seguroSA.inserir(new Apolice("1", 400));
		seguroSA.inserir(new Apolice("2", 300));

		//Auditoria

		AuditorGenerico auditor = new AuditorGenerico();

		//Polimorfismo com Interface. Perceba que agora s temos um auditor que audita qualquer banco
		// que implementa a interface QualquerBanco. Auditar um novo tipo de banco  fcil.
		System.out.println("Resultado auditoria Banco de Investimento: " + auditor.investigaBanco(itau));
		System.out.println("Resultado auditoria Banco de Seguros: " + auditor.investigaBanco(seguroSA));

	}

}
